#include <cstdio>
#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <cmath>
#include <cassert>
#include <memory.h>
#include <queue>
#include <deque>
#include <stack>
#include <list>
#include <map>
#include <set>
#include <functional>
#include <cstring>
#include <ctime>

using namespace std;

#define all(a) a.begin(), a.end()
#define mp make_pair

typedef long long li;
typedef long double ld;
typedef pair<int, int> pi;
typedef vector<int> vi;

#define FILENAME ""

void solve();
int main() {
#ifdef YA
	string s = FILENAME;
	//assert(!s.empty());
	clock_t start = clock();
	freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#else
	//freopen(FILENAME ".in", "r", stdin);
	//freopen(FILENAME ".out", "w", stdout);
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);
#endif
	cout.sync_with_stdio(0);
	cin.tie(0);
	cout.precision(15);
	cout << fixed;

	int t = 1;
	//cin >> t;
	while(true) {
		solve();
	}
#ifdef YA
	cout << "\n\n" << (clock() - start) / 1.0 / CLOCKS_PER_SEC << "\n\n";
#endif
	return 0;
}


//#define int li

struct vertical{
	ld pos;
	ld len;
	int nex;
	vertical() {}
	vertical(ld pos, ld len, int nex):pos(pos), len(len), nex(nex) {}
};

ld eps = 1e-9;

ld dfgh(ld a) {
	return sqrt(fabs(a));
}

#define sqrt dfgh




void solve() {
	int n;
	cin >> n;
	if (n == 0)
		exit(0);
	vector<ld> x(n), r(n);
	ld ans = 0;
	for (int i = 0; i < n; ++i) {
		cin >> x[i] >> r[i];
		ans = max(ans, r[i] * sqrt(2.0));
	}

	stack<vertical> st;
	st.push(vertical(x[0] - r[0], 0, 0));

	vector<vertical> prev(n);

	vector<ld> intersections(n);
	
	for (int i = 1; i < n; ++i) {
		ld d = x[i] - x[i - 1];
		ld prevCos = (d * d + r[i - 1] * r[i - 1] - r[i] * r[i]) / 2 / d / r[i - 1];
		ld prevSin = sqrt(1 - prevCos * prevCos);
		ld len = r[i - 1] * prevSin;
		ld pos = x[i - 1] + r[i - 1] * prevCos;
		vertical curVert(pos, len, i);
		while(st.top().len + eps > curVert.len)
			st.pop();
		prev[i - 1] = st.top();
		st.push(curVert);
		intersections[i - 1] = len;
	}

	while(!st.empty())
		st.pop();

	vector<vertical> next(n);

	st.push(vertical(x[n - 1] + r[n - 1], 0, n - 1));

	for (int i = n - 2; i >= 0; --i) {
		ld d = x[i + 1] - x[i];
		ld prevCos = (d * d + r[i + 1] * r[i + 1] - r[i] * r[i]) / 2 / d / r[i + 1];
		ld prevSin = sqrt(1 - prevCos * prevCos); 
		ld len = r[i + 1] * prevSin;
		ld pos = x[i + 1] - r[i + 1] * prevCos;
		vertical curVert(pos, len, i);
		while(st.top().len + eps > curVert.len)
			st.pop();
		next[i] = st.top();
		st.push(curVert);
	}

	for (int i = 0; i + 1 < n; ++i) {
		int idPrev = prev[i].nex;
		ld curLen = intersections[i];
		ld firstX = x[idPrev] - sqrt(r[idPrev] * r[idPrev] - curLen * curLen);
		int idNext = next[i].nex;
		ld lastX = x[idNext] + sqrt(r[idNext] * r[idNext] - curLen * curLen);

		if (lastX - firstX + eps > 2 * curLen) {
			ans = max(ans, curLen * 2);
			continue;
		}

		ld L = 0;
		ld R = curLen;

		for (int w = 0; w < 50; ++w) {
			ld M = (L + R) / 2;
			firstX = x[idPrev] - sqrt(r[idPrev] * r[idPrev] - M * M);
			lastX = x[idNext] + sqrt(r[idNext] * r[idNext] - M * M);
			if (lastX - firstX < M * 2)
				R = M;
			else
				L = M;
		}

		ans = max(ans, L * 2);
	}

	cout << ans << "\n";

}